<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso Restringido</title>
    <style>
        /* 1. Estilos del cuerpo de la página */
        body {
            /* Elimina los márgenes predeterminados del navegador */
            margin: 0;
            /* Oculta cualquier parte del GIF que se salga de la pantalla */
            overflow: hidden;
            /* Usa la fuente 'sans-serif' como respaldo */
            font-family: Arial, sans-serif;
            /* Centra el texto */
            text-align: center;
        }

        /* 2. Contenedor del GIF de Fondo */
        .gif-background {
            /* Fija la posición para que cubra toda la ventana (viewport) */
            position: fixed;
            top: 0;
            left: 0;
            /* Ancho y alto del 100% de la ventana */
            width: 100vw;
            height: 100vh;
            /* Indica la ruta de tu archivo GIF */
            background-image: url('https://blackddit.nyc3.cdn.digitaloceanspaces.com/posts/inmyfans.com.gif'); 
            /* Esto es crucial para que el GIF cubra todo el espacio sin repetirse */
            background-size: cover;
            /* Centra la imagen si el tamaño no coincide exactamente con la ventana */
            background-position: center center;
            /* No repetir el GIF */
            background-repeat: no-repeat;
            /* Asegura que el GIF esté detrás de cualquier mensaje */
            z-index: -1; 
        }

        /* 3. Estilos del mensaje de texto */
        .content {
            /* Asegura que el texto esté por encima del GIF */
            position: relative; 
            /* Para centrar verticalmente el mensaje */
            height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            /* Estilo del texto */
            color: white; /* Color blanco para que contraste con la mayoría de GIFs */
            text-shadow: 2px 2px 4px black; /* Sombra para mejor legibilidad */
        }
    </style>
</head>
<body>

    <div class="gif-background"></div>

    <div class="content">
        <h1>¡Acceso Restringido!</h1>
        <p>No tienes permiso para ver el contenido de esta carpeta.</p>
    </div>

</body>
</html>